<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/

require_once APPPATH.'libraries/attachment.php';

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class PDF_attachment extends Attachment{		
	
	public function view(){
		header('Content-Type: application/pdf');
		header('Content-Disposition: inline; filename="' . $this->name . '"');
		echo $this->binary_string;
	}
	
	public function download(){		
		header('Content-Type: application/download');
		header('Content-Disposition: attachment; filename="' . $this->name . '"');
		header('Content-Transfer-Encoding: binary');
		echo $this->binary_string;
	}	
	
/////////////////////
// STATIC FUNCTIONS
/////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		if(empty($binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()), $name);
		if(!static::matches_file($name, $binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()), $name);
		return new PDF_attachment(array_merge(compact('name', 'binary_string'), $more_values));
	}

	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		if(empty($binary_string)) return false;
		return strtolower(pathinfo($name, PATHINFO_EXTENSION)) == 'pdf';
	}
	
}
?>